define(['angular', 'app'], function (angular, app) {
	"use strict";
	app.service('NotificationsInstanceBuilderService', function (NotificationsService) {

		var NotificationsInstanceBuilderService = {};

		NotificationsInstanceBuilderService.instances = {};

		NotificationsInstanceBuilderService.instance = function(key) {
			if(!NotificationsInstanceBuilderService.instances[key]) {
				NotificationsInstanceBuilderService.instances[key] = new NotificationsService();
			}

			return NotificationsInstanceBuilderService.instances[key];
		};

		NotificationsInstanceBuilderService.hasLiveInstance = function(key) {
			return !!NotificationsInstanceBuilderService.instances[key];
		};

		return NotificationsInstanceBuilderService;

	});
});